﻿var DialogResources = {

    m_Resources: {},

    Set: function (key, value) {

        try {

            var lowercasekey = key.toLowerCase();
            this.m_Resources[lowercasekey] = value;
        }
        catch (e) {
        }
    },

    Get: function (key, data, defaultvalue) {

        var lowercasekey = key.toLowerCase();

        var ressource = this.m_Resources[lowercasekey];
        if (ressource == undefined) {
            return defaultvalue + ". Reason: " + data.m_szReason;
        }

        var value = ressource.callback(ressource, data);
        return value;

    },

    getCmd: function (data) {

        var cmd = "unknown-command";
        try {

            if (data && data.m_szCmd)
                cmd = data.m_szCmd;

        }catch( e ){

        }

        
        return cmd;
    },

    socketdisconnect: function (resource, data) {

        try {
            return resource.message[0] + data.m_szPeerName + " " + resource.message[1] + resource.message[2] + data.m_szReason;
        }
        catch (e) {
            return this.getCmd(data) + " -- caught an exception when trying to display telephony server not in service alert message... reason: " + e.message;
        }
    },

    httperror: function (ressource, data) {

        try {
            return ressource.message[0] + data.m_szCmd + ". " + ressource.message[1] + " " + data.m_szSystemError;
        }
        catch (e) {
            return DialogResources.getCmd() + " -- caught an exception when trying to display request timeout alert message... reason: " + e.message;
        }
    },

    requesttimeout: function (resource, data) {

        try {
            return resource.message[0] + data.m_szCmd + resource.message[1] + data.m_szPeerName + resource.message[2];
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display request timeout alert message... reason: " + e.message;
        }
    },

    general: function (resource, data) {

        try {
            var message = "";
            if (resource.message.length < 2)
                message = resource.message[0];
            else
                message = resource.message[0] + ". " + resource.message[1] + data.m_szReason;

            return message;
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display general alert message... reason: " + e.message;
        }
    },

    notsignedon: function (resource, data) {
        try {
            return resource.message[0];
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when  trying  to display alert message.... reason: " + e.message;
        }
    },

    relogindialog: function (resource, data) {
        try {
            return resource.message[0] + " ( pronto id " + data.m_szProntoNo + " )." + resource.message[1] + " ";
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when  trying  to display alert message.... reason: " + e.message;
        }
    },

    // Waiting message used to guide Supervisor during audo connection establishment (next 6 message dialog)
    waitingORAAuthenticate: function (resource, data) {
        try {
            return resource.message[0] + " (" + data.m_szSupervisorExtensionNumber + "). " + resource.message[1] + " " + data.m_szSupervisorId + "#";
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display waiting message for remote outbound agent with authentication-- reason: " + e.message;
        }
    },

    waitingORAAuthenticateAccessCode: function (resource, data) {
        try {
            return resource.message[0] + " (" + data.m_szSupervisorExtensionNumber + "). " + resource.message[1] + " " + data.m_szSecureAccessCode + ". " + resource.message[2] + " " + data.m_szSupervisorId + "#";
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display waiting message for remote outbound agent with authentication and secured access code -- reason: " + e.message;
        }
    },

    waitingORA: function (resource, data) {
        try {
            return resource.message[0] + " (" + data.m_szSupervisorExtensionNumber + ").";
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display waiting message for remote outbound agent -- reason: " + e.message;
        }
    },

    waitingORAAccessCode: function (resource, data) {
        try {
            return resource.message[0] + " (" + data.m_szSupervisorExtensionNumber + ")." + resource.message[1] + " " + data.m_szSecureAccessCode + ". ";
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display waiting message for remote outbound agent with secured access code -- reason: " + e.message;
        }
    },

    waitingIRAAccessCode: function (resource, data) {
        try {
            return resource.message[0] + " " + data.m_szSupervisorExtensionNumber + ". " + resource.message[1] + " " + data.m_szSecureAccessCode + ". " + resource.message[2] + " " + data.m_szSupervisorId + "#";
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display waiting message for remote inbound agent with secured access code -- reason: " + e.message;
        }
    },

    waitingIRA: function (resource, data) {
        try {
            return resource.message[0] + " " + data.m_szSupervisorExtensionNumber + ". " + resource.message[1] + " " + data.m_szSupervisorId + "#";
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display waiting message for remote inbound agent -- reason: " + e.message;
        }
    },

    oraremoteagentdialog: function (resource, data) {
        try {
            return resource.message[0] + " " + resource.message[1] + " " + data.m_szPhoneNumber;
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display alert message. Not able to proceed with re-login command... reason: " + e.message;
        }
    },

    iraremoteagentdialog: function (resource, data) {
        try {
            return resource.message[0] + ". " + resource.message[1] + " " + data.m_szPhoneNumber + " " + resource.message[2] + " " + data.m_szAgentId;
        }
        catch (e) {
            return DialogResources.getCmd(data) + " -- caught an exception when trying to display alert message. Not able to proceed with re-login command... reason: " + e.message;
        }
    }
};

var Dialog =
{
    //  m_document      : le document HTML
    //  m_debugforward  : permet un broadcast des dialogs si defini

    m_document: null,
    m_debugforward: null,
    m_szDialog: "",
    m_Resource: { confirmationTitle: "Confirmation", alertTitle: "alert" },

    init: function (document, resource) {
        this.m_document = document;
        this.m_Resource.confirmationTitle = resource.confirmationTitle;
        this.m_Resource.alertTitle = resource.alertTitle;
    },

    createYesButton: function (callback) {
        return {
            Text: resources.Yes,
            CssClass: "primary",
            Action: function () {
                Dialog._debug("user press the -Yes- button");
                if ($.isFunction(callback)) {
                    callback.apply(null, [true]);
                }
            }
        }
    },

    createNoButton: function (callback) {
        return {
            Text: resources.No,
            Action: function () {
                Dialog._debug("user press the -No- button");
                if ($.isFunction(callback)) {
                    callback.apply(null, [false]);
                }
            }
        }
    },

    createCloseButton: function (callback) {
        return {
            Text: resources.Close,
            Action: function () {
                Dialog._debug("user press the -Close- button");
                if ($.isFunction(callback)) {
                    callback.apply(null, [false]);
                }
            }
        }
    },

    createConfirmDialog: function (message, callback) {
        var buttons = [
            Dialog.createYesButton(callback),
            Dialog.createNoButton(callback)
        ]

        modalDialog.showCustomDialog(message, resources.Confirm, buttons, 300, 500);
    },

    createInfoDialog: function (message, callback) {
        var buttons = [
            Dialog.createCloseButton(callback)
        ]

        modalDialog.showCustomDialog(message, resources.Monitor, buttons, 300, 500);
    },

    createAlertDialog: function (message, callback) {
        var buttons = [Dialog.createCloseButton(callback)];
        modalDialog.showCustomDialog(message, "Error", buttons, 300, 500);
    },

    _debug: function (message, bLog) {
        if (Dialog.m_debugforward == undefined || Dialog.m_debugforward == null) {
            console.log(message);
            return;
        }

        Dialog.m_debugforward(message, bLog);
        return;
    }
};